	function [f0, f1] = FRM_IIR_FIR(edge1, edge2, Delta_p, Delta_s, P, M, N1, N2)
	
	% Optimizing FIR/IIR FRM filters  
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	%	Author: 			Tapio Saramaki 17.11.1997
	%	Modified by:	
	%	Copyright:			by authors - not released for commercial use
	%	Version:			1	 
	%	Known bugs:	 
	%	Report bugs to:		tapio.saramaki@tut.fi
	
	%**************************************
	edge1=edge1/pi; edge2 = edge2/pi; % TO BE REMOVED LATER
	%**************************************
	
	disp(['Optimizing! Pleasee wait!'])
	
	% Reorder the poles to suit the optimization function	 
	A = P;  A(imag(A) ~= 0) = []; rP = A;
	A = P; A(imag(A) <= 0) = [];
	B = P; B(imag(B) >= 0) = [];
	P = [flipud(sort(B)); rP; sort(A)];
	
	
	g1 = [0 0 0];	g2 = [0 0 0];	fx = [1 1 0 0]; 
	for n = 1:12
		[g2, Err2] = FRM_REMEZ(N2,edge2,fx,2,M,g1,g2,P,2*Delta_p,2*Delta_s,{160});
		[GG,w] = zeroam(g2,0.0,edge2(2),10000); g2 = g2/max(GG);
		[g1, Err1] = FRM_REMEZ(N1,edge1,fx,1,M,g1,g2,P,2*Delta_p,2*Delta_s,{160});
		[GG,w] = zeroam(g1,0.0,edge1(2),10000);	g1 = g1/max(GG);
	end

	a = 2^(1/16);		aa = 2;
	for k = 1:16
		aa = aa/a;
		for n = 1:12 
			[g2, Err2] = FRM_REMEZ(N2,edge2,fx,2,M,g1,g2,P,aa*Delta_p,aa*Delta_s,{160});
			[GG,w] = zeroam(g2,0.0,edge2(2),10000); g2 = g2/max(GG);
			[g1, Err1] = FRM_REMEZ(N1,edge1,fx,1,M,g1,g2,P,aa*Delta_p,aa*Delta_s,{160});
			[GG,w] = zeroam(g1,0.0,edge1(2),10000);	g1 = g1/max(GG);
		end
	end
	a = 2^(1/128); 	delta_s = sqrt(Delta_s);	delta_p = 1-sqrt(1-Delta_p);
	while 1
		delta_p = delta_p/a;			delta_s = delta_s/a;
		Deltaa_p = 1-(1-delta_p)^2;		Deltaa_s = delta_s^2; 
		for n = 1:12 
			[g2, Err2] = FRM_REMEZ(N2,edge2,fx,2,M,g1,g2,P,Deltaa_p,Deltaa_s,{160});
			[GG,w] = zeroam(g2,0.0,edge2(2),10000); g2 = g2/max(GG);
			[g1, Err1] = FRM_REMEZ(N1,edge1,fx,1,M,g1,g2,P,Deltaa_p,Deltaa_s,{160});			
			[GG,w] = zeroam(g1,0.0,edge1(2),10000); g1 = g1/max(GG);
		end
		if (Err1 < 0.5 | Err1 > 1) | (Err2 < 0.5 | Err2 > 1)
			break
		end
		f0 = g1;	f1 = g2; 	deltafin_p = delta_p, deltafin_s = delta_s
	end

